﻿var surveyTemplates = {
    datatable: null,
    changeCategoryItems: null,
    refreshDataTable: function () {
        surveyTemplates.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-templatesTable").a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetTemplates", "SurveyTemplates", "Library"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Class": "id" },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "Class": "v-name", "HideInSelector": true },
                { "Name": "Category", "Title": resources.Category, "Data": "Category" },
                { "Name": "UseS2", "Title": resources.NewLookAndFeel, "Data": "UseS2", "Type": "boolean", "ShowIcon": true }
            ],
            localizableTexts: { "Search": resources.SearchThemes },
            allowRowSelection: function (row) {
                return surveyTemplates.canBeModified(row);
            },
            defaultSorting: { Column: "Name", Ascending: true },
            stateKey: "SurveyTemplates",
            toolBarItems: surveyTemplates.getToolBarItems(),
            contextMenuItems: surveyTemplates.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                switch (action) {
                    case "delete":
                        surveyTemplates.deleteItems(ids);
                        break;
                    case "changeCategory":
                        surveyTemplates.changeItemsCategory(ids);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        surveyTemplates.editItem(row.Id, row.UseS2);
                        break;
                    case "properties":
                        surveyTemplates.editItemProperties(row.Id);
                        break;
                    case "delete":
                        surveyTemplates.deleteItems(row.Id);
                        break;
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.OldLookAndFeel, "AjaxParams": { "useS2": false } },
                    { "Label": resources.NewLookAndFeel, "AjaxParams": { "useS2": true } }
                ]
            },
        });
    },
    changeItemsCategory: function (items) {
        surveyTemplates.changeCategoryItems = items;
        modalDialog.showWindow(a4.getAction("ItemsCategoryEditor", "SurveyTemplates", "Library", { fileId: items[0] }), 250, 450, { afterClose: function () { surveyTemplates.changeItemsCategoryOnClose(); } });
    },
    changeItemsCategoryOnSave: function (categoryId) {
        a4.callServerMethod(a4.getAction("UpdateItemsCategory", "SurveyTemplates", "Library"), { itemIds: surveyTemplates.changeCategoryItems, categoryId: categoryId },
            function (result) {
                surveyTemplates.changeCategoryItems = null;
                surveyTemplates.refreshDataTable();
                modalDialog.close();
            },
            function (error) {
                surveyTemplates.changeCategoryItems = null;
                modalDialog.close();
                var message = eval("(" + error.responseText + ")").Message;
                a4.showErrorMessage(message);
            });
    },
    changeItemsCategoryOnClose: function (categoryId) {
        surveyTemplates.changeCategoryItems = null;
    },
    deleteItems: function (items) {

        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteThemeResources, function () {
            a4.callServerMethod(a4.getAction("DeleteItems", "SurveyTemplates", "Library"), { itemIds: items },
                function (result) {
                    surveyTemplates.refreshDataTable();
                });
        }, 250, 400, true, { "count": itemsCount });
    },
    editItem: function (itemId, useS2) {
        var action = useS2 ? "ThemeEditorS2" : "ThemeEditor";
        modalDialog.showWindow(a4.getAction(action, "SurveyTemplates", "Library", { themeId: itemId }), "98%", "98%", { closeButton: false, afterClose: function () { surveyTemplates.refreshDataTable(); } });
    },
    editItemProperties: function (itemId) {
        modalDialog.showWindow(a4.getAction("PropertiesEditor", "SurveyTemplates", "Library", { themeId: itemId }), 300, 500);
    },
    updateItemPropertiesOnSave: function (categoryId, name, themeId) {
        a4.callServerMethod(a4.getAction("UpdateItemProperties", "SurveyTemplates", "Library"), { themeId: themeId, categoryId: categoryId, name: name },
            function (result) {
                surveyTemplates.refreshDataTable();
                modalDialog.close();
            },
            function (error) {
                modalDialog.close();
                var message = eval("(" + error.responseText + ")").Message;
                a4.showErrorMessage(message);
            });
    },
    bindEvents: function () {

        $(document).on("click", ".h-manage-category", function () {
            modalDialog.showWindow(a4.getAction("CategoriesEditor", "SurveyTemplates", "Library"), 500, 950, { afterClose: function () { surveyTemplates.datatable.a4datatable("refresh", true); } });
        });
    },
    canBeModified: function (theme) {
        return theme.Category != "Default Themes";
    },
    getContextMenuItems: function () {
        if (typeof canModify !== 'undefined' && canModify) {
            return [{ "Action": "edit", "Label": resources.Edit, "DisplayCondition": function (data) { return surveyTemplates.canBeModified(data); } },
                { "Action": "properties", "Label": resources.Properties, "DisplayCondition": function (data) { return surveyTemplates.canBeModified(data); } },
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return surveyTemplates.canBeModified(data); } }];
        } else return [];
    },
    getToolBarItems: function () {
        if (typeof canModify !== 'undefined' && canModify) {
            return [{ "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return surveyTemplates.canBeModified(data); } },
                { "Action": "changeCategory", "Label": resources.ChangeCategory, "DisplayCondition": function (data) { return surveyTemplates.canBeModified(data); } }];
        } else return [];
    }
}

$(document).ready(function () {
    surveyTemplates.initializeDataTable();
    surveyTemplates.bindEvents();
});